/*
 * Decompiled with CFR 0.152.
 */
package org.magmafoundation.magma.forge;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraftforge.registries.ForgeRegistries;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_18_R2.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_18_R2.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.potion.PotionEffectType;
import org.magmafoundation.magma.Magma;
import org.magmafoundation.magma.configuration.MagmaConfig;
import org.magmafoundation.magma.craftbukkit.entity.CraftCustomEntity;
import org.magmafoundation.magma.helpers.EnumJ17Helper;

public class ForgeInject {
    public static BiMap<ResourceKey<LevelStem>, World.Environment> environment = HashBiMap.create((Map)ImmutableMap.builder().put((Object)LevelStem.f_63971_, (Object)World.Environment.NORMAL).put((Object)LevelStem.f_63972_, (Object)World.Environment.NETHER).put((Object)LevelStem.f_63973_, (Object)World.Environment.THE_END).build());
    public static final Map<Villager.Profession, ResourceLocation> PROFESSION_MAP = new ConcurrentHashMap<Villager.Profession, ResourceLocation>();
    public static final Map<net.minecraft.world.entity.EntityType<?>, String> ENTITY_TYPES = new ConcurrentHashMap();

    public static void init() {
        ForgeInject.debug("Injecting Forge Material into Bukkit");
        ForgeInject.addForgeItems();
        ForgeInject.debug("Injecting Forge Blocks into Bukkit");
        ForgeInject.addForgeBlocks();
        ForgeInject.debug("Injecting Forge Enchantments into Bukkit");
        ForgeInject.addForgeEnchantments();
        ForgeInject.debug("Injecting Forge Potions into Bukkit");
        ForgeInject.addForgePotions();
        ForgeInject.debug("Injecting Forge Biomes into Bukkit");
        ForgeInject.addForgeBiomes();
        ForgeInject.debug("Injecting Forge Entities into Bukkit");
        ForgeInject.addForgeEntities();
        ForgeInject.debug("Injecting Forge VillagerProfessions into Bukkit");
        ForgeInject.addForgeVillagerProfessions();
        ForgeInject.debug("Injecting Forge into Bukkit: DONE");
    }

    private static void debug(String message) {
        if (MagmaConfig.instance.debugPrintInjections.getValues().booleanValue()) {
            Magma.LOGGER.warn(message);
        } else {
            Magma.LOGGER.debug(message);
        }
    }

    private static void addForgeItems() {
        ForgeRegistries.ITEMS.getEntries().forEach(entry -> {
            ResourceLocation resourceLocation = ((Item)entry.getValue()).getRegistryName();
            assert (resourceLocation != null);
            if (!resourceLocation.m_135827_().equals("minecraft")) {
                String materialName = ForgeInject.normalizeName(((ResourceKey)entry.getKey()).toString()).replace("RESOURCEKEYMINECRAFT_ITEM__", "");
                Item item = (Item)entry.getValue();
                int id = Item.m_41393_((Item)item);
                try {
                    Material material = Material.addMaterial(materialName, id, false, resourceLocation.m_135827_(), CraftNamespacedKey.fromMinecraft(resourceLocation));
                    if (material == null) {
                        Magma.LOGGER.warn("Could not inject item into Bukkit: " + materialName);
                        return;
                    }
                    CraftMagicNumbers.ITEM_MATERIAL.put(item, material);
                    CraftMagicNumbers.MATERIAL_ITEM.put(material, item);
                    ForgeInject.debug("Injecting Forge Material into Bukkit: " + material.name());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        ForgeInject.debug("Injecting Forge Material into Bukkit: DONE");
    }

    private static void addForgeBlocks() {
        ForgeRegistries.BLOCKS.getEntries().forEach(entry -> {
            ResourceLocation resourceLocation = ((Block)entry.getValue()).getRegistryName();
            assert (resourceLocation != null);
            if (!resourceLocation.m_135827_().equals("minecraft")) {
                String materialName = ForgeInject.normalizeName(((ResourceKey)entry.getKey()).toString()).replace("RESOURCEKEYMINECRAFT_BLOCK__", "");
                Block block = (Block)entry.getValue();
                int id = Item.m_41393_((Item)block.m_5456_());
                try {
                    Material material = Material.addMaterial(materialName, id, true, resourceLocation.m_135827_(), CraftNamespacedKey.fromMinecraft(resourceLocation));
                    if (material == null) {
                        Magma.LOGGER.warn("Could not inject block into Bukkit: " + materialName);
                        return;
                    }
                    CraftMagicNumbers.BLOCK_MATERIAL.put(block, material);
                    CraftMagicNumbers.MATERIAL_BLOCK.put(material, block);
                    ForgeInject.debug("Injecting Forge Blocks into Bukkit: " + material.name());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        ForgeInject.debug("Injecting Forge Blocks into Bukkit: DONE");
    }

    private static void addForgeEnchantments() {
        ForgeRegistries.ENCHANTMENTS.getEntries().forEach(entry -> {
            CraftEnchantment enchantment = new CraftEnchantment((Enchantment)entry.getValue());
            if (!org.bukkit.enchantments.Enchantment.byKey.containsKey(enchantment.getKey()) || !org.bukkit.enchantments.Enchantment.byName.containsKey(enchantment.getName())) {
                org.bukkit.enchantments.Enchantment.byKey.put(enchantment.getKey(), enchantment);
                org.bukkit.enchantments.Enchantment.byName.put(enchantment.getName(), enchantment);
                ForgeInject.debug("Injecting Forge Enchantments into Bukkit: " + enchantment.getName());
            }
        });
        ForgeInject.debug("Injecting Forge Enchantments into Bukkit: DONE");
    }

    private static void addForgePotions() {
        ForgeRegistries.MOB_EFFECTS.getEntries().forEach(entry -> {
            CraftPotionEffectType pet = new CraftPotionEffectType((MobEffect)entry.getValue());
            if (PotionEffectType.byId[pet.getId()] == null || !PotionEffectType.byName.containsKey(((PotionEffectType)pet).getName().toLowerCase(Locale.ENGLISH)) || !PotionEffectType.byKey.containsKey(pet.getKey())) {
                PotionEffectType.byId[pet.getId()] = pet;
                PotionEffectType.byName.put(((PotionEffectType)pet).getName().toLowerCase(Locale.ENGLISH), pet);
                PotionEffectType.byKey.put(pet.getKey(), pet);
                ForgeInject.debug("Injecting Forge Potion into Bukkit: " + ((PotionEffectType)pet).getName());
            }
        });
        ForgeInject.debug("Injecting Forge Potion into Bukkit: DONE");
    }

    private static void addForgeBiomes() {
        ArrayList map = new ArrayList();
        ForgeRegistries.BIOMES.getEntries().forEach(entry -> {
            String biomeName = Objects.requireNonNull(((net.minecraft.world.level.biome.Biome)entry.getValue()).getRegistryName()).m_135827_();
            if (!biomeName.equals("minecraft") && !map.contains(biomeName)) {
                map.add(biomeName);
                try {
                    Biome biome = EnumJ17Helper.addEnum0(Biome.class, biomeName, new Class[0], new Object[0]);
                    ForgeInject.debug("Injecting Forge Biome into Bukkit: " + biome.name());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        map.clear();
        ForgeInject.debug("Injecting Forge Biome into Bukkit: DONE");
    }

    private static void addForgeEntities() {
        ForgeRegistries.ENTITIES.getEntries().forEach(entity -> {
            ResourceLocation resourceLocation = ((net.minecraft.world.entity.EntityType)entity.getValue()).getRegistryName();
            assert (resourceLocation != null);
            if (!resourceLocation.m_135827_().equals("minecraft")) {
                String entityType = ForgeInject.normalizeName(resourceLocation.toString());
                int typeId = entityType.hashCode();
                try {
                    EntityType bukkitType = EnumJ17Helper.addEnum0(EntityType.class, entityType, new Class[]{String.class, Class.class, Integer.TYPE, Boolean.TYPE}, entityType.toLowerCase(), CraftCustomEntity.class, typeId, false);
                    EntityType.NAME_MAP.put(entityType.toLowerCase(), bukkitType);
                    EntityType.ID_MAP.put((short)typeId, bukkitType);
                    ENTITY_TYPES.put((net.minecraft.world.entity.EntityType)entity.getValue(), entityType);
                    ForgeInject.debug("Injecting Forge Entity into Bukkit: " + entityType);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        ForgeInject.debug("Injecting Forge Entity into Bukkit: DONE");
    }

    private static void addForgeVillagerProfessions() {
        ForgeRegistries.PROFESSIONS.forEach(villagerProfession -> {
            ResourceLocation resourceLocation = villagerProfession.getRegistryName();
            assert (resourceLocation != null);
            if (!resourceLocation.m_135827_().equals("minecraft")) {
                String name = ForgeInject.normalizeName(resourceLocation.toString());
                try {
                    Villager.Profession profession = EnumJ17Helper.addEnum0(Villager.Profession.class, name, new Class[0], new Object[0]);
                    PROFESSION_MAP.put(profession, resourceLocation);
                    ForgeInject.debug("Injecting Forge VillagerProfession into Bukkit: " + profession.name());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        ForgeInject.debug("Injecting Forge VillagerProfession into Bukkit: DONE");
    }

    public static void addForgeEnvironment(Registry<LevelStem> registry) {
        int i = World.Environment.values().length;
        for (Map.Entry entry : registry.m_6579_()) {
            ResourceKey key = (ResourceKey)entry.getKey();
            World.Environment environment1 = (World.Environment)((Object)environment.get((Object)key));
            if (environment1 != null) continue;
            String name = ForgeInject.normalizeName(key.m_135782_().toString());
            int id = i - 1;
            environment1 = EnumJ17Helper.addEnum(World.Environment.class, name, new Class[]{Integer.TYPE}, new Object[]{id});
            environment.put((Object)key, (Object)environment1);
            ForgeInject.debug(String.format("Injected new Forge DimensionType %s.", new Object[]{environment1}));
            ++i;
        }
    }

    private static String normalizeName(String name) {
        return name.toUpperCase(Locale.ENGLISH).replaceAll("(:|\\s)", "_").replaceAll("\\W", "");
    }
}

